#include <AFMotor.h>
#include <QTRSensors.h>

#define KP 0.13     // Oranlı kazanç
#define KD 3.55     // Türevsel kazanç
#define LED_PIN 2

AF_DCMotor motor1(4);  // Sol motor
AF_DCMotor motor2(3);  // Sağ motor

#define NUM_SENSORS 6
QTRSensorsRC qtrrc((unsigned char[]) {A0, A1, A2, A3, A4, A5}, NUM_SENSORS, 2500, QTR_NO_EMITTER_PIN);
uint16_t sensorValues[NUM_SENSORS];

int16_t position = 0;
int16_t lastError = 0;
int16_t baseSpeed = 210;
int16_t maxSpeed = 255;
bool calibrated = false;

void setup() {
  Serial.begin(9600);
  pinMode(LED_PIN, OUTPUT);

  Serial.println("Kalibrasyon başlıyor...");
  autoCalibrate();  // Hareketli, az dönüşlü ve 250+ tekrar kalibrasyon
  Serial.println("Kalibrasyon tamamlandı.");

  motor1.run(RELEASE);
  motor2.run(RELEASE);
  digitalWrite(LED_PIN, HIGH);
  delay(3500);  // Kalibrasyon sonrası bekleme süresi

  calibrated = true;
}

void loop() {
  if (calibrated) {
    position = qtrrc.readLine(sensorValues);

    int16_t error = position - 2500;
    int16_t motorSpeedCorrection = KP * error + KD * (error - lastError);

    int16_t leftMotorSpeed = baseSpeed + motorSpeedCorrection;
    int16_t rightMotorSpeed = baseSpeed - motorSpeedCorrection;

    leftMotorSpeed = constrain(leftMotorSpeed, -maxSpeed, maxSpeed);
    rightMotorSpeed = constrain(rightMotorSpeed, -maxSpeed, maxSpeed);

    motorControl(leftMotorSpeed, rightMotorSpeed);
    lastError = error;
  }
}

void motorControl(int16_t leftSpeed, int16_t rightSpeed) {
  motor1.setSpeed(abs(leftSpeed));  
  motor2.setSpeed(abs(rightSpeed));  

  if (leftSpeed > 0) motor1.run(FORWARD);
  else if (leftSpeed < 0) motor1.run(BACKWARD);

  if (rightSpeed > 0) motor2.run(FORWARD);
  else if (rightSpeed < 0) motor2.run(BACKWARD);
}

void autoCalibrate() {
  const int stepCount = 25;         // Her turda 25 adım
  const int repetitions = 5;        // 5 ileri-geri turu (toplam 250 kalibrasyon)
  const int speed = 110;             // Sağ teker hız
  const int stepDelay = 5;         // Adım süresi (ms)

  for (int r = 0; r < repetitions; r++) {
    // Sağ teker ileri küçük adımlarla
    for (int i = 0; i < stepCount; i++) {
      qtrrc.calibrate();
      motor1.setSpeed(0);            // Sol teker sabit
      motor2.setSpeed(speed);       
      motor2.run(FORWARD);
      delay(stepDelay);
    }

    // Sağ teker geri küçük adımlarla
    for (int i = 0; i < stepCount; i++) {
      qtrrc.calibrate();
      motor1.setSpeed(0);
      motor2.setSpeed(speed);       
      motor2.run(BACKWARD);
      delay(stepDelay);
    }
  }

  motor1.run(RELEASE);
  motor2.run(RELEASE);
}
