#include <AFMotor.h>
#include <QTRSensors.h>

#define KP 0.12 // Daha hızlı tepki için oranlı kazanç artırıldı
#define KD 3.85  // Türevsel kazanç artırılarak hızlı hız değişimlerine karşı denge sağlandı
#define LED_PIN 2

AF_DCMotor motor1(4);  
AF_DCMotor motor2(3);  

#define NUM_SENSORS 6
QTRSensorsRC qtrrc((unsigned char[]) {A0, A1, A2, A3, A4, A5}, NUM_SENSORS, 2500, QTR_NO_EMITTER_PIN);
uint16_t sensorValues[NUM_SENSORS];

int16_t position = 0;
int16_t lastError = 0;
int16_t baseSpeed = 120;  // Temel hız 230 olarak ayarlandı
int16_t maxSpeed = 170;
bool calibrated = false;

void setup() {
  Serial.begin(9600);

  Serial.println("Kalibrasyon başlıyor...");
  
  for (int i = 0; i < 400; i++) {
    qtrrc.calibrate(); 
  }
  Serial.println("Kalibrasyon tamamlandı.");
  motor1.run(RELEASE);
  motor2.run(RELEASE);
  delay(3500);

  unsigned long startTime = millis();
  while(millis() - startTime < 5000) {
    digitalWrite(LED_PIN, HIGH);
    delay(250);
    digitalWrite(LED_PIN, LOW);
    delay(250);
  }

  calibrated = true;
}

void loop() {
  if (calibrated) {
    position = qtrrc.readLine(sensorValues);

    int16_t error = position - 2500;  // Sensör hatasını hesapla
    int16_t motorSpeedCorrection = KP * error + KD * (error - lastError);

    int16_t leftMotorSpeed = baseSpeed + motorSpeedCorrection;
    int16_t rightMotorSpeed = baseSpeed - motorSpeedCorrection;

    // Hızları sınırla
    leftMotorSpeed = constrain(leftMotorSpeed, -maxSpeed, maxSpeed);
    rightMotorSpeed = constrain(rightMotorSpeed, -maxSpeed, maxSpeed);

    // Motorları kontrol et
    motorControl(leftMotorSpeed, rightMotorSpeed);

    lastError = error;
  }
}

void motorControl(int16_t leftSpeed, int16_t rightSpeed) {
  motor1.setSpeed(abs(leftSpeed));  
  motor2.setSpeed(abs(rightSpeed));  

  if (leftSpeed > 0) {
    motor1.run(FORWARD);
  } if (leftSpeed < 0) {
    motor1.run(BACKWARD);
  }

  if (rightSpeed > 0) {
    motor2.run(FORWARD);
  } if (rightSpeed < 0) {
    motor2.run(BACKWARD);
  } 
}
